;~@sa1 <-- DO NOT REMOVE THIS LINE!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; A very successful thwomp which erratically smashes the ground
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
                    ; symbolic names for RAM addresses (don't change these)
                    !SPRITE_Y_SPEED  = $9E
                    !SPRITE_X_SPEED  = $B6
                    !SPRITE_STATE    = $D8
                    !SPRITE_Y_POS    = $3216
                    !ORIG_Y_POS      = $3284
                    !EXPRESSION      = $329A
                    !FREEZE_TIMER    = $32C6
                    !SPR_OBJ_STATUS  = $334A
                    !H_OFFSCREEN     = $3376
                    !V_OFFSCREEN     = $7642
                    
                    ; definitions of bits (don't change these)
                    !IS_ON_GROUND    = $04             

					;things you should not need touching
X_OFFSET:            db $FC,$04,$FC,$04,$00 
Y_OFFSET:            db $00,$00,$10,$10,$08 
                                                                      
					
					;DATA WHICH YOU CAN EDIT
					
					; subroutine calls
					!GET_DRAW_INFO = $23800F
					!SUB_HORZ_POS = $238095
					!SUB_VERT_POS = $2380A8
					!SUB_OFF_SCREEN = $2380BB
					!MAKE_BLOCK = $2380CC
					
                    ; sprite data
                    !SPRITE_GRAVITY  = $70
                    !MAX_Y_SPEED     = $3E 
                    !RISE_SPEED      = $F0
                    !TIME_TO_SHAKE   = $18
                    !SOUND_EFFECT    = $09 
                    !TIME_ON_GROUND  = $01
					
					; graphics data
                    !ANGRY_TILE      = $CA  ;sp3 and 4 by default, see few lines below to change that.
TILE_MAP:            db $8E,$8C,$AE,$AC,$C8 ;top right, top left, bottom right, bottom left, the pissed-off-but-not-quite face
PROPERTIES:          db $03,$03,$03,$03,$03  ;defines tile properties. change to 02 02 02 02 02 if graphics are in SP1 and 2. yxppccct and all


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite init JSL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                    PRINT "INIT ",pc
                    LDA !SPRITE_Y_POS,x  
                    STA !ORIG_Y_POS,x
                    LDA $322C,x  
                    CLC        
                    ADC #$08   
                    STA $322C,x  
					
					JSL $01ACF9
					LDA $748E
					AND #$3F
					STA $33FA,x
					
                    RTL
      

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite code JSL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                    PRINT "MAIN ",pc                                    
                    PHB                     
                    PHK                     
                    PLB                     
                    JSR SPRITE_CODE_START   
                    PLB                     
                    RTL                     


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite main code 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

RETURN:              RTS  

SPRITE_CODE_START:   JSR SUB_GFX

                    LDA $3242,x             ; RETURN if sprite status != 8
                    CMP #$08            	 
                    BNE RETURN           
                    
                    LDA $9D			        ; RETURN if sprites locked
                    BNE RETURN    
                    
                    JSL !SUB_OFF_SCREEN     ; only process sprite while on screen           
                    
                    JSL $01A7DC             ; interact with mario 
                    
					LDA $33FA,x
					BNE RETURN
					
                    LDA !SPRITE_STATE,x     
                    CMP #$01
                    BEQ FALLING
                    CMP #$02
                    BEQ RISING

;-----------------------------------------------------------------------------------------
; state 0
;-----------------------------------------------------------------------------------------

HOVERING:            LDA !V_OFFSCREEN,x       ;fall if offscreen vertically
                    BNE SET_FALLING
                    
                    LDA !H_OFFSCREEN,x       ;RETURN if offscreen horizontally
                    BNE RETURN0

SET_FALLING:         LDA #$02                    ;set expression    
                    STA !EXPRESSION,x  

                    INC !SPRITE_STATE,x          ;chage state to FALLING

                    LDA #$00     
                    STA !SPRITE_Y_SPEED,x        ;set initial speed

RETURN0:             RTS                     

;-----------------------------------------------------------------------------------------
; state 1
;-----------------------------------------------------------------------------------------

FALLING:             JSL $01801A             ;apply speed
                    
                    LDA !SPRITE_Y_SPEED,x    ;increase speed if below the max
                    CMP #!MAX_Y_SPEED
                    BCS DONT_INC_SPEED
                    ADC #!SPRITE_GRAVITY
                    STA !SPRITE_Y_SPEED,x    
DONT_INC_SPEED:
                    JSL $019138             ;interact with objects
                    
                    LDA !SPR_OBJ_STATUS,x    ;RETURN if not on the ground
					AND #!IS_ON_GROUND
                    BEQ RETURN1
                    
                    JSR SUB_9A04            ; ?? speed related
                    
                    LDA #!TIME_TO_SHAKE      ;shake ground
                    STA $7887    
			
					LDA #!SOUND_EFFECT       ;play sound effect
                    STA $7DFC    
                    
                    LDA #!TIME_ON_GROUND     ;set time to stay on ground
                    STA !FREEZE_TIMER,x  
                    
                    INC !SPRITE_STATE,x      ;go to RISING state
RETURN1:             RTS                     

;-----------------------------------------------------------------------------------------
; state 2
;-----------------------------------------------------------------------------------------

RISING:              LDA !FREEZE_TIMER,x      ;if we're still waiting on the ground, RETURN
                    BNE RETURN2
                    
                    STZ !EXPRESSION,x        ;reset expression
                    
                    LDA !SPRITE_Y_POS,x      ;check if the sprite is in original position
                    CMP !ORIG_Y_POS,x  
                    BNE RISE
                    
                    STZ !SPRITE_STATE,x      ;reset state to HOVERING
					
					JSL $01ACF9
					LDA $748E
					AND #$3F
					STA $33FA,x
					
                    RTS                     

RISE:                LDA #!RISE_SPEED         ;set RISING speed and apply it
                    STA !SPRITE_Y_SPEED,x     
                    JSL $01801A             
RETURN2:             RTS

SUB_GFX:             JSL !GET_DRAW_INFO
                    
                    LDA !EXPRESSION,x   
                    STA $02       
                    PHX                     
                    LDX #$03                
                    CMP #$00                        
                    BEQ LOOP_START
                    INX                     
LOOP_START:          LDA $00    
                    CLC                     
                    ADC X_OFFSET,x
                    STA $6300,y

                    LDA $01    
                    CLC                     
                    ADC Y_OFFSET,x
                    STA $6301,y

                    LDA PROPERTIES,x
                    ORA $64    
                    STA $6303,y

                    LDA TILE_MAP,x
                    CPX #$04                
                    BNE NORMAL_TILE
                    PHX                     
                    LDX $02    
                    CPX #$02                
                    BNE NOT_ANGRY
                    LDA #!ANGRY_TILE               
NOT_ANGRY:           PLX                     
NORMAL_TILE:         STA $6302,y

                    INY                     
                    INY                     
                    INY                     
                    INY                     
                    DEX                     
                    BPL LOOP_START

                    PLX                     
                                   
                    LDY #$02                ; \ 460 = 2 (all 16x16 tiles)
                    LDA #$04                ;  | A = (number of tiles drawn - 1)
                    JSL $01B7B3             ; / don't draw if offscreen
                    RTS                     ; RETURN


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; speed related
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                    
SUB_9A04:            LDA !SPR_OBJ_STATUS,x
                    BMI THWOMP_1
                    LDA #$00                
                    LDY $7520,x
                    BEQ THWOMP_2
THWOMP_1:            LDA #$18
THWOMP_2:            STA !SPRITE_Y_SPEED,x  
                    RTS                                   