!MarioHP = $747B
!LuigiHP = $747D
!ShowHealthBars = $78B4

; CTRL+f .hptable in order to find the tiles used for the graphics
; do the same with .HealthTiles

!GET_DRAW_INFO = $23800F
!SUB_HORZ_POS = $238095
!SUB_VERT_POS = $2380A8
!SUB_OFF_SCREEN = $2380BB
!MAKE_BLOCK = $2380CC

	PRINT "INIT ",pc
	STZ !ShowHealthBars		;initially hide the health bar. change from STZ to INC if you want the health bar to be shown anyway
	RTL

	PRINT "MAIN ",pc                                   
	PHB                     
	PHK                     
	PLB        				
	JSR Main
	PLB                     
	RTL                     

Main:
	LDA !ShowHealthBars
	BEQ .nohealthbaryet
	JSR HealthBarGFX
.nohealthbaryet
	RTS
	
; ====================================
;   Graphics routine
; ====================================
HealthBarGFX:
;16x16 tiles
	JSL !GET_DRAW_INFO

	PHX
	LDX #$03			; 4 16x16 tiles
-
	LDA .HealthX,x
	STA $6300,y

	LDA .HealthY,x
	STA $6301,y
	
	LDA .HealthTiles,x
	STA $6302,y
	
	LDA .HealthProp,x
	ORA $64
	STA $6303,y
	
	PHY
	TYA
	LSR
	LSR
	TAY
	LDA #$02
	STA $6460,y
	PLY
	
	INY
	INY
	INY
	INY
	
	DEX
	BPL -
	PLX

;8x8 tiles
;Mario
	PHX
	LDA !MarioHP
	STA $0F
	STZ $0E
	JSR FillHealthBar

;Luigi
	LDA !LuigiHP
	STA $0F
	LDA #12
	STA $0E
	JSR FillHealthBar

	PLX
	RTS
	
.HealthX
	db $08,$08
	db $E8,$E8
	
.HealthY
	db $18,$58
	db $18,$58
	
.HealthTiles
	db $E4,$E6				; top cap of health bar, then M
	db $E4,$E8				; top cap of health bar, then L
	
.HealthProp
	db $01,$01
	db $0F,$0F
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Graphics, health bar
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FillHealthBar:
	PHX
	LDX #11
-
	PHX
	TXA
	CLC
	ADC $0E
	TAX

	LDA .HPX,x
	STA $6300,y
	
	LDA .HPY,x
	STA $6301,y

	PHX
	LDA $0F
	BPL +
	LDA #$00
+	CMP #$04
	BCC +
	LDA #$04
+	TAX
	LDA .HPTable,x
	PLX
	STA $6302,y
	
	LDA .HPProp,x
	ORA #$30
	STA $6303,y
	
	PHY
	TYA
	LSR
	LSR
	TAY
	LDA #$00
	STA $6460,y
	PLY
	
	TXA
	AND #$01
	BNE +
	LDA $0F
	SEC
	SBC #$04
	STA $0F
+	PLX
	
	INY
	INY
	INY
	INY
		
	DEX
	BPL -

	PLX
	RTS

.HPTable
	db $F2,$F1,$F0,$E1,$E0		;graphics for bar with: 0 ticks, 1 tick, 2 ticks, 3 ticks, 4 ticks. these are all 8x8 tiles
	
.HPX
.Mario_HPX
	db $08,$10,$08,$10,$08,$10
	db $08,$10,$08,$10,$08,$10
.Luigi_HPX
	db $E8,$F0,$E8,$F0,$E8,$F0
	db $E8,$F0,$E8,$F0,$E8,$F0

.HPY
.Mario_HPY
	db $28,$28,$30,$30,$38,$38
	db $40,$40,$48,$48,$50,$50
.Luigi_HPY
	db $28,$28,$30,$30,$38,$38
	db $40,$40,$48,$48,$50,$50

.HPProp	
.Mario_HPProp	
	db $01,$41,$01,$41,$01,$41
	db $01,$41,$01,$41,$01,$41
.Luigi_HPProp	
	db $0F,$4F,$0F,$4F,$0F,$4F
	db $0F,$4F,$0F,$4F,$0F,$4F