;~@sa1 <-- DO NOT REMOVE THIS LINE!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; "YOU THOUGHT KOOPA WORKED ALONE?" *smug*
;;
;; Notable codes:
;; To find the sprite's clipping routine to adjust its clipping size, 
;;    ctrl+f "SPRITE CLIPPING ROUTINE"
;; To find the sprite's screen edges routine (so it doesn't walk off-screen), 
;;    ctrl+f "SCREEN EDGES ROUTINE"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Global commonly used subroutines
;; They shall be called with a JSL.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	!GET_DRAW_INFO = $23800F
	!SUB_HORZ_POS = $238095
	!SUB_VERT_POS = $2380A8
	!SUB_OFF_SCREEN = $2380BB
	!MAKE_BLOCK = $2380CC

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; General-purpose RAM addresses
;; These addresses do not decrement every frame, thus they 
;; can be used for keeping track of stuff like count,
;; phases, etc.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	!SpriteMode = $329A,x
	!GraphicsPointer = $33CE,x

	!XSpeed = $B6,x
	!YSpeed = $3200,x

	!XPosLo = $322C,x
	!YPosLo = $3216,x
	!XPosHi = $326E,x
	!YPosHi = $3258,x
	!Direction = $3334,x
	
	!CurrentExecutedMove = $3360,x
	!AllPurposeVariable = $33E4,x
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Timer RAM addresses
;; These addresses decrement by 1 every frame until they
;; reach $00. After that, they remain $00.
;; These can be used for stuff like graphics animation,
;; timed sprite actions, invincibility frames, and so on.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	!Timer1 = $32C6,x
	!Invincibility = $33FA,x
	!GFXTimer = $338C,x
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Init routine. Here you can initialize stuff like the
;; sprite's initial position, amount of hitpoints, etc.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	PRINT "INIT ",pc
	STZ !Timer1
	LDA #24
	STA !MarioHP
	LDA #0
	STA !LuigiHP
	LDA #$FF
	STA !CurrentExecutedMove
	RTL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Main routine call
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	PRINT "MAIN ",pc                                   
	PHB                     
	PHK                     
	PLB        				
	JSR Main
	PLB                     
	RTL                     

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Various pointers which are used during sprite execution
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
; Pointers to sprite phase routines, controlled by !SpriteMode
LuigiStates:
	dw ControlMario					; $00 - Mario walks, notices the sp00ky thing in the 3rd window
	dw LuigiAppears					; $01 - Enter Luigi, Mario looks shocked, creepy K3fka laugh, etc etc.
	dw FillLuigiHP					; $02 - Fills Luigi's HP while he's looking smug
	dw BossFight					; $03 - The main bossfight, where Luigi casts all the attacks and everything. Mario regains control here.
	dw ClearBossAreaFromSprites		; $04 - The moment the boss battle ends, all sprites except the health bar and Luigi are cleared. Mario loses control.
	dw GetInPositionForTheFinish	; $05 - Luigi walks to his position for the final hit
	dw FinishHim					; $06 - Mario regains control basically.
	dw FlyingLuigi					; $07 - Handle Luigi flying, show appropriate GFX frames
	dw IAMBURNINGUPPPPP				; $08 - OH GOD NO then store to gamemode for The End.
	
LuigiGFX:
	dw Graphics_None				; Literally nothing
	dw Graphics_Koopa				; YOU THOUGHT KOOPA WORKED ALONE?
	dw Graphics_OH_GOD_NO			; OH GOD NO
	dw Graphics_Walking				; Walking. Actually animated.
	dw Graphics_Victory				; Victory pose
	dw Graphics_Kick				; Kick pose
	dw Graphics_Stand				; Standing pose
	dw Graphics_Evil_Pose			; Evil smug pose
	dw Graphics_Throw_1				; Throw frame 1
	dw Graphics_Throw_2				; Throw frame 2
	dw Graphics_Throw_3				; Throw frame 3
	dw Graphics_Observe				; Some awkward observe graphics
	dw Graphics_SpinJump			; Animated spinjump graphics
	dw Graphics_Hurt1				; Luigi's only hurt graphics
	dw Graphics_Jump				; Jumping frame
	dw Graphics_Fall				; Falling frame
	dw Graphics_Kneeling			; Kneeling frame for when he's about to be finished.
	dw Graphics_WalkingLeft			; Walking frame, hardcoded towards left direction
	dw Graphics_WalkingRight		; Walking frame, hardcoded towards right direction
	dw Graphics_HurtKnockBack		; Hurt frame for when Luigi's finished, airborne frame 1
	dw Graphics_Lying				; "" , airborne frame 2
	dw Graphics_HurtKnockBack2		; "" , airborne frame 3
	
;Graphics list of definitions for the sake of easy to remember names, so that I can do something like
; LDA #!GraphicsModeNone
; STA !GraphicsPointer

!GraphicsModeNone = $00
!GraphicsModeKoopa = $01
!GraphicsModeOHGODNO = $02
!GraphicsModeWalking = $03
!GraphicsModeVictory = $04
!GraphicsModeKick = $05
!GraphicsModeStand = $06
!GraphicsModeEvilPose = $07
!GraphicsModeThrowFrame1 = $08
!GraphicsModeThrowFrame2 = $09
!GraphicsModeThrowFrame3 = $0A
!GraphicsModeObserve = $0B
!GraphicsModeSpinJump = $0C
!GraphicsModeHurt = $0D
!GraphicsModeJump = $0E
!GraphicsModeFall = $0F
!GraphicsModeKneeling = $10
!GraphicsModeWalkingLeft = $11
!GraphicsModeWalkingRight = $12
!GraphicsModeHurtKnockBack = $13
!GraphicsModeLying = $14
!GraphicsModeHurtKnockBack2 = $15

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Main loop - this is where the game checks the current sprite action
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Main:
	LDA !SpriteMode
	CMP #$02
	BCC +
	JSL !SUB_OFF_SCREEN
+
	JSR UpdateDirection		; Update the direction flag so Luigi faces Mario properly sometimes

	; This code here handles the invincibility flashing
	LDA !Invincibility
	BEQ .noiframes
	LSR A
	LSR A
	LSR A
	PHX
	TAX
	LDA.l $00E292,x			;iframe interval timer
	PLX
	AND !Invincibility
	ORA $9D
	BEQ .continue 
.noiframes
	PEA.w .continue-1		; IMPORTANT: After the JMP (LuigiGFX,x) thing, this makes sure an RTS will result in the code returning to .continue a bit below this
	
	; This code here handles the hurt-specific frame
	LDA !Invincibility
	CMP #$66
	BCC .nohurtframe
	LDA #!GraphicsModeHurt
	BRA .proceedGFX
.nohurtframe	
	; End code block
	LDA !GraphicsPointer
.proceedGFX
	ASL A
	PHX
	TAX
	JMP (LuigiGFX,x)		; Execute graphics routine first before the actual MAIN routine

.continue
	LDA $9D					; if sprites are locked, skip...
	BNE +
	JSL $01802A				;update sprite speed values and all (with gravity)
+
	JSL MarioInteraction	;Interaction with mario
	
	; This here executes the actual sprite main routine
	LDA !SpriteMode
	ASL A
	PHX
	TAX
	JMP (LuigiStates,x)
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Mario Interaction Routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MarioInteraction:
		LDA !SpriteMode
		CMP #$06				; After a certain sprite mode, check for sprite cape interaction rather than jumped-on interaction
		BCC +
		JMP AtMercyCapeInteraction

+		LDA !Invincibility		;No interaction at all if Luigi is flashing
		BNE .proceed
		LDA $9D					;No interaction at all if sprites are locked
		BNE .proceed

		JSL $03B664
		JSR GetSpriteClipping
		JSL $03B72B
		BCC .proceed

		LDA $7D
		CMP #$08
		BMI .marioloses

.mariowins
		LDA !GraphicsPointer
		CMP #!GraphicsModeSpinJump	;can't jump on a spinjumping luigi.
		BEQ .NOTQUITE
		
		LDA #$28
		STA $7DFC
		JSL $01AA33 ;Boost Mario
		JSL $01AB9E ;Contact GFX

		LDA #$7F				; Set invincibility frames
		STA !Invincibility
		
		LDA !LuigiHP
		SEC	
		SBC #24					; How much health Luigi loses when he gets jumped on
		STA !LuigiHP
		;DEC !LuigiHP
		
		LDA !LuigiHP
		BNE +
		
		; If Luigi's health hits exactly $00
		; (Be careful when you reduce Luigi's health by more than 1, might want to change the above BNE to BPL then I think)
		LDA #$A0
		STA !Timer1
		LDA #$04				; \
		STA !SpriteMode			; / End the bossfight
+		BRA .proceed

; Luigi does get jumped on, but when he is doing the spinjump animation, which makes him invulnerable to damage
.NOTQUITE
		LDA #$02
		STA $7DF9	;click SFX
		JSL $01AA33 ;Boost Mario
		JSL $01AB9E ;Contact GFX
		
		LDA $7497
		BNE +
		LDA #$10			;just to avoid accidental damaging of Mario, make him invulnerable for 16 frames
		STA $7497
+		BRA .proceed

.marioloses
		JSL $00F5B7 ;hurt mario		
.proceed
		RTL
		
AtMercyCapeInteraction:
		JSL GetCapeClipping
		JSR GetSpriteClipping
		JSL $03B72B
		BCC .proceed

		; Code block executes when Luigi gets smacked by the cape
		LDA #$07			; The moment Luigi gets smacked by the cape, set sprite mode to 07
		STA !SpriteMode
		LDA #$FF
		STA !Timer1
		LDY !Direction
		LDA .speedtbl,y
		STA !XSpeed			; Launch Luigi upwards depending on the direction
		LDA #$B0
		STA !YSpeed
		JSR GenSpark
		LDA #$02
		STA $7DF9
.proceed
	RTL

.speedtbl
	db $10,$F0
	
GenSpark:
		LDA !XPosLo
		CMP $1A
		LDA !XPosHi
		SBC $1B
		BNE .Return
		LDA !YPosLo
		CMP $1C
		LDA !YPosHi
		SBC $1D
		BNE .Return
		LDY #$03
.FindFree
		LDA $77C0,y
		BEQ .FoundOne
		DEY
		BPL .FindFree
.Return	
		RTS

.FoundOne	
		LDA #$02
		STA $77C0,y
		LDA !YPosLo
		STA $77C4,y
		LDA !XPosLo
		STA $77C8,y
		LDA #$03
		STA $77CC,y
		RTS			

; SPRITE CLIPPING ROUTINE
GetSpriteClipping:
	LDA !XPosLo
	CLC
	ADC #$06			; X offset
	STA $04
	LDA !XPosHi
	ADC #$00			
	STA $0A
	LDA.b #$0F-$06 		; Width of sprite clipping
	STA $06
	LDA !YPosLo
	SEC
	SBC #$08			; Y offset
	STA $05
	SBC #$00
	LDA !YPosHi
	STA $0B
	LDA #$18			; Height of sprite clipping
	STA $07
	RTS

; Quick subroutine call to get Mario's cape clipping
GetCapeClipping:
	PHK
	PEA.w .jslrtsreturn-1
	PEA.w $02B889-1
	JML $029696
.jslrtsreturn
	RTL
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #1 - Mario enters room, walks forward, looks up and sees weird window thing
; When I look back at this, I think this one is coded pretty sloppy!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ControlMario:
	PLX
	LDA #$0B	; This disables Mario's controls
	STA $71

	LDA !Timer1
	BNE ++
	LDA $7E
	CMP #$22
	BCS +
	LDA #$12	; Set Mario's speed so he walks towards a certain position
	STA $7B
	RTS
+
	LDA #$40
	STA !Timer1
	RTS
++
	CMP #$01
	BNE +
	;next sprite mode
	LDA #$01
	STA !SpriteMode
	+
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #2 - Enter Luigi from the right, look smug, say KOOPA line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

LuigiAppears:
	PLX
	LDA !XPosHi
	XBA
	LDA !XPosLo
	REP #$20
	CMP #$00E0			;position where luigi stops
	SEP #$20
	BCC .inposition
	LDA #$F0			; Set Luigi's speed
	STA !XSpeed
	BRA .continue
.inposition
	LDA !XSpeed
	BEQ +
	INC !XSpeed			; When he's in position, make him stop *smoothly*. yes, I even took care of that detail
	BNE +
	LDA #$29
	STA $7DFB			;THAT CREEPY K3FKA LAUGH
	LDA #$A0
	STA !Timer1
	LDA #!GraphicsModeKoopa
	STA !GraphicsPointer
+
	LDA #$0D
	STA $73E0
	BRA .continuenopose
.continue
	LDA #!GraphicsModeWalking
	STA !GraphicsPointer
	LDA #$33	;pose
	STA $73E0
.continuenopose
	LDA !Timer1
	CMP #$01
	BNE +
;next sprite mode
	LDA #$02		;once timer runs out, start showing hp bars and go to next phase
	STA !SpriteMode
	LDA #$1F        ;music
	STA $7DFB
	INC !ShowHealthBars
+
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #3 - Fill HP bars
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FillLuigiHP:
	PLX
	LDA !Timer1
	BNE +
	LDA #$FF
	STA !Timer1
+
	LDA #!GraphicsModeEvilPose
	STA !GraphicsPointer	
	LDA !Timer1
	CMP #$C0
	BCS +
	LDA $14
	AND #$01
	BNE +
	LDA !LuigiHP
	CMP #24
	BEQ +
	LDA #$01
	STA $7DFC
	INC !LuigiHP
+
	LDA !Timer1
	CMP #$40
	BNE +
	STZ !Timer1
	LDA #$03
	STA !SpriteMode
	STZ $71
+
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #4 - Boss fight starts.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Attack pattern, decided by RNG.
; To make an attack occur more frequently, place it in the pointer table more frequently.
Attacks:
	dw TossLargeFireball				;[DONE] Luigi puts his hands up, summons a Ludwig von Koopa (correct name??) fireball in front of him.
	dw TossLargeFireball				;[DONE] same
	dw FireDash							;[DONE] blah
	dw SwitchPosition					;[DONE] Luigi (spin)jumps after Mario at a medium height (still stompable, manageable), ludwig fire after every spinjump
	dw SwitchPosition					;[DONE] places multiple 16x16 fireballs on the screen (they appear with a puff of smoke) and they slowly start accelerating towards Mario's direction
	dw TossLargeFireball				;[DONE]
	dw FireRain							;[DONE, could use sfx?] Luigi 'summons' those fireballs from Bowser's fight and lets them rain down in a similar fashion.
	dw Podoboos							;[DONE] Luigi starts summoning triple Podoboos from the lava three times. their spawning position is marked by small fireballs spitting from the lava.
	
;Uses !timer1
;Y = amount of frames the move should last
StartMoveTimer:
	LDA !Timer1
	BNE +
	TYA
	STA !Timer1
+	RTS

;Uses !timer1
EndMoveIfTimerExpired:
	LDA !Timer1
	CMP #$01
	BNE +
	STZ !Timer1
	
	; You can add code here which executes whenever a move has ended.
	
	LDA #$FF
	STA !CurrentExecutedMove	
+	RTS


;Just to make JSRs look less ugly
macro StartMoveTimer(arg1)
LDX $75E9	;get sprite index
LDY <arg1>
JSR StartMoveTimer
endmacro
macro EndMoveTimer()
JSR EndMoveIfTimerExpired
endmacro

; Don't update Luigi's direction if he's invincible, don't want his hurt 
; frame to be facing Mario constantly, that'd be fucking weird.
UpdateDirection:
	LDA !Invincibility
	CMP #$66				; Should be the same value as the hurt frame graphics check thing
	BCC .nohurtframe
	RTS

.nohurtframe
	JSL !SUB_HORZ_POS
	TYA
	EOR #$01
	STA !Direction
	RTS

; SCREEN EDGES ROUTINE
CheckScreenEdgeBlocked:
	LDA $30B6,x
	BPL .goingright
.goingleft
	;check if need to block from the left
	LDA !XPosHi
	XBA
	LDA !XPosLo
	REP #$20
	CMP #$0007			;position where luigi has to stop when going left. This is the left screen edge
	SEP #$20
	BCS .proceed
	STZ $30B6,x
	BRA .proceed
.goingright
	;check if need to block from the right
	LDA !XPosHi
	XBA
	LDA !XPosLo
	REP #$20
	CMP #$00E8			;position where luigi has to stop when going right. This is the right screen edge
	SEP #$20
	BCC .proceed
	STZ $30B6,x
.proceed
	RTS
	
; Carry is set when Luigi is standing on the ground
CheckGroundBlocked:
	CLC
	LDA $309E,x
	BMI +			;don't check for ground interaction when upwards speed
	LDA $334A,x
	AND #$04		;blocked from below
	BEQ +
	SEC
+	RTS
	
TossLargeFireball:
	%StartMoveTimer(#25)		; This sets Timer1

	%EndMoveTimer()				; If timer1 has ended, it sets a flag which makes Luigi execute another random move
	RTS

FireDash:
	%StartMoveTimer(#$FF)
	
	%EndMoveTimer()
	RTS

SwitchPosition:
	%StartMoveTimer(#$FF)

	%EndMoveTimer()
	RTS

FireRain:
	%StartMoveTimer(#$F1)

	%EndMoveTimer()
	RTS
	
Podoboos:
	%StartMoveTimer(#$FF)

	%EndMoveTimer()
	RTS

; MAIN ATTACK PATTERN CODE	
Think:
	LDA !CurrentExecutedMove
	CMP #$FF
	BNE .continuemove
	JSL $01ACF9							;RNG
	LDA $748E							;Random number
	AND #$07							; 8 possible moves
	STA !CurrentExecutedMove
.continuemove
	ASL A
	PEA.w .continue-1
	TAX
	JMP (Attacks,x)
.continue
	RTS

BossFight:
	PLX
	JSR Think
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #5 - Clear the boss fight, bring everything to a halt
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ClearBossAreaFromSprites:
	PLX
	LDA #$80
	STA $7DFB	;fade out music
	LDA #$0B	;freeze mario. i.e. disable controls
	STA $71		;00 enables it again

	LDY #$13
-	LDA $3242,y
	BNE .foundsprite
.keepsearching
	DEY
	BPL -
	BRA .continue

.foundsprite
	PHX
	TYX
	LDA $400083,x
	PLX
	CMP #$04			;ignore luigi himself
	BEQ .keepsearching
	CMP #$06			;ignore health bar
	BEQ .keepsearching
	LDA #$00
	STA $3242,y
	BRA .keepsearching
	
.continue
	LDA #!GraphicsModeHurt
	STA !GraphicsPointer

	STZ $30B6,x		;set x speed to 0
	JSR CheckGroundBlocked			;if touching the ground
	BCC .notblocked
	STZ $309E,x		;set y speed to 0 too
.notblocked
	LDA !Timer1
	CMP #$01
	BNE +
	LDA #$05
	STA !SpriteMode	;start walking
+
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #6 - Luigi walks to his spot
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
GetInPositionForTheFinish:
	PLX
	LDA !XPosHi
	XBA
	LDA !XPosLo
	REP #$20
	CMP #$0080			;position where luigi has to be
	SEP #$20
	BEQ .inposition
	BCC .toleft
	BCS .toright

.toleft
	LDA #$0B
	STA !XSpeed
	LDA #!GraphicsModeWalkingLeft
	STA !GraphicsPointer
	BRA .continue
.toright
	LDA #$F4
	STA !XSpeed
	LDA #!GraphicsModeWalkingRight
	STA !GraphicsPointer
	BRA .continue
.inposition
	LDA #$80
	STA !XPosLo
	STZ !XSpeed
	STZ !ShowHealthBars
	STZ $71		;00 enables mario controls again
	LDA #!GraphicsModeKneeling
	STA !GraphicsPointer
	;instantly turn into cape mario with animation and sfx and all
	LDA #$02                
	STA $19      
	LDA #$0D                ; \ Play sound effect 
	STA $7DF9               ; / 
	JSL $01C5AE         
	INC $9D

	LDA #$06
	STA !SpriteMode	;start the finish battle thing
.continue
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #7 - Mario can finish Luigi
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
FinishHim:
	LDA #!GraphicsModeKneeling
	STA !GraphicsPointer
	PLX
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #8 - Luigi gets knocked back n shit
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
FlyingLuigi:
	PLX
	STZ $7B			;stop mario's movements
	LDA #$0B	;freeze mario. i.e. disable controls
	STA $71		;00 enables it again
	
	LDA $3242,x
	CMP #$05
	BNE .notinlava
	;the moment luigi touches the lava
	LDA.b #180
	STA !Timer1
	LDA #$08
	STA !SpriteMode
	RTS
.notinlava
	
	LDA !Timer1
	CMP #$E0
	BCC +
	JMP .nextcheck
+
	LDA #!GraphicsModeHurtKnockBack2
	STA !GraphicsPointer
	
	JSR CheckGroundBlocked
	BCS .blocked
	JMP .notblocked

.blocked
	LDA #$70
	STA $98
	LDA #$01
	STA $99
	LDA !XPosLo
	AND #$F0
	STA $9A
	STZ $9B
	LDA #$02
	STA $9C
	JSL $00BEB0
	PHB
	LDA #$02
	PHA
	PLB
	LDA #$00
	JSL $028663
	PLB
	
	LDA #$70
	STA $98
	LDA #$01
	STA $99
	LDA !XPosLo
	AND #$F0
	CLC
	ADC #$10
	STA $9A
	STZ $9B
	LDA #$02
	STA $9C
	JSL $00BEB0

	LDA #$70
	STA $98
	LDA #$01
	STA $99
	LDA !XPosLo
	AND #$F0
	CLC
	ADC #$20
	STA $9A
	STZ $9B
	LDA #$02
	STA $9C
	JSL $00BEB0
	PHB
	LDA #$02
	PHA
	PLB
	LDA #$00
	JSL $028663
	PLB
	
	LDA #$70
	STA $98
	LDA #$01
	STA $99
	LDA !XPosLo
	AND #$F0
	SEC
	SBC #$10
	STA $9A
	STZ $9B
	LDA #$02
	STA $9C
	JSL $00BEB0
	
	LDA #$70
	STA $98
	LDA #$01
	STA $99
	LDA !XPosLo
	AND #$F0
	SEC
	SBC #$20
	STA $9A
	STZ $9B
	LDA #$02
	STA $9C
	JSL $00BEB0
	PHB
	LDA #$02
	PHA
	PLB
	LDA #$00
	JSL $028663
	PLB
	
.notblocked
	BRA .proceed
	
.nextcheck
	LDA !Timer1
	CMP #$E8
	BCS +
	LDA #!GraphicsModeLying
	STA !GraphicsPointer
	BRA .proceed
+	LDA !Timer1
	CMP #$F8
	BCS +
	LDA #!GraphicsModeHurtKnockBack ;;
	STA !GraphicsPointer
	BRA .proceed
+	LDA !Timer1
	CMP #$FF
	BCS +
	LDA #!GraphicsModeHurt
	STA !GraphicsPointer
	BRA .proceed
+
.proceed
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ACTION #9 - OH GOD NO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
IAMBURNINGUPPPPP:
	PLX
	LDA #$08
	STA $3242,x
	STZ !XSpeed
	STZ !YSpeed
	
	; The moment Luigi hits the lava, this timer starts running, when it hits 00, it erases Luigi
	; I don't want that, I want my own timer running and then end the game rather than erase Luigi
	LDA #$FF
	STA $32F2,x		;forever sinking in mud
	
	LDA #!GraphicsModeOHGODNO
	STA !GraphicsPointer
	
	LDA $14
	AND #$1F
	CMP #$1F
	BNE +
	JSR .luigilavasplash		; Show lavasplashes on luigi. for some reason it half-works.
+
	
	LDA !Timer1
	BNE +
	LDA #$01
	STA $3400
	LDA #$FF		;end the level
	STA $7493		;that was one hell of a ride.
+	RTS
	
.luigilavasplash
	LDA #$20
	STA $7DFC
	LDA !YPosLo
	PHA
	LDA #$90
	STA !YPosLo
	LDA !XPosLo
	PHA
	STA !XPosLo
	JSL $02852B
	PLA
	STA !XPosLo
	PLA
	STA !YPosLo
	RTS
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;;	Graphics start here
;;;;    The cool thing about this is that each frame has their own code running
;;;;    Allowing you maximum control over each and every frame.
;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; No graphics
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_None:
	PLX
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;You thought koopa worked alone GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Koopa:
	PLX
	JSL !GET_DRAW_INFO

	PHX
	LDX #$0A
	-
	LDA $00
	CLC
	ADC .messagetilesx,x
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .messagetilesy,x
	STA $6301,y

	LDA .messagetiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	STA $6303,y

	INY #4
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$0A                ;
	JSL $01B7B3
	RTS

.messagetiles
	db $6C,$4C,$00,$02,$04,$06,$08,$0A,$22,$24,$26
.messagetilesx
	db $00,$00,$B0,$C0,$D0,$E0,$F0,$00,$C8,$D8,$E8
.messagetilesy
	db $00,$F0,$E0,$E0,$E0,$E0,$E0,$E0,$F0,$F0,$F0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Victory Pose GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Victory:
	PLX
	JSL !GET_DRAW_INFO

	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.standtiles
	db $60,$6C

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Walking GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Walking:
	PLX
	JSL !GET_DRAW_INFO

	LDA !GFXTimer
	BNE +
	LDA #$17
	STA !GFXTimer
	+

	LDA $00
	STA $6300,y

	PHX
	LDA !GFXTimer
	TAX
	LDA $01
	CLC
	ADC .voff,x
	STA $6301,y

	LDA .feettiles,x
	STA $6302,y
	PLX

	LDA !Direction
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY #4

	LDA $00
	STA $6300,y

	PHX
	LDA !GFXTimer
	TAX
	LDA $01
	CLC
	ADC .voff,x
	ADC #$F0
	STA $6301,y
	PLX

	LDA .headtile
	STA $6302,y

	LDA !Direction
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64

	STA $6303,y

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.feettiles
	db $2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A
	db $4A,$4A,$4A,$4A,$4A,$4A,$4A,$4A
	db $6A,$6A,$6A,$6A,$6A,$6A,$6A,$6A

.headtile
	db $40

.voff
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $01,$01,$01,$01,$01,$01,$01,$01

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Kick GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Kick:
	PLX
	JSL !GET_DRAW_INFO

	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .kicktiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.kicktiles
	db $40,$62

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Stand GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Stand:
	PLX
	LDA !Direction
	STA $0C
	JSL !GET_DRAW_INFO

	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.standtiles
	db $40,$6A

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Evil Grin on camera GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Evil_Pose:
	PLX
	JSL !GET_DRAW_INFO

	PHX
	LDX #$01
-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.standtiles
	db $60,$80

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Throw Frames
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Throw_1:
	LDA #$00
	STA $09
	PLX
	BRA Graphics_Throw 
Graphics_Throw_2:
	LDA #$02
	STA $09
	PLX
	BRA Graphics_Throw 
Graphics_Throw_3:
	LDA #$04
	STA $09
	PLX
	BRA Graphics_Throw 
Graphics_Observe:
	LDA #$06
	STA $09
	PLX
	BRA Graphics_Throw 

Graphics_Throw:
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
-
	LDA $00
	STA $6300,y

	LDA $01
	ADC .voff,x
	STA $6301,y

	PHX
	TXA
	CLC
	ADC $09
	TAX
	LDA .throwtiles,x
	STA $6302,y
	PLX

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.throwtiles
	db $44,$64	;throw pose 1
	db $46,$66	;throw pose 2
	db $48,$68	;throw pose 3
	db $A6,$C6	;observe pose

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Spin Jump
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_SpinJump:
	PLX
	JSL !GET_DRAW_INFO

	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$F1
	STA $6301,y

	PHX
	LDA $14
	AND #$07
	LSR A
	TAX
	LDA .headtiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	ORA .xflip,x
	STA $6303,y
	PLX

	INY
	INY
	INY
	INY
	
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	STA $6301,y

	PHX
	LDA $14
	AND #$07
	LSR A
	TAX
	LDA .bodytiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	ORA .xflip,x
	STA $6303,y
	PLX
	
	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.headtiles
db $40,$8C,$40,$60
.bodytiles
db $6A,$AC,$6A,$AE

.xflip
db $00,$00,$40,$00
	
.voff
	db $F0,$00
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Hurt GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Hurt1:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .hurttiles,x
	STA $6302,y
	
	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.hurttiles
	db $4E,$6E
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Jump GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Jump:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .jumptiles,x
	STA $6302,y
	
	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.jumptiles
	db $40,$8A
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Fall GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Fall:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .falltiles,x
	STA $6302,y
	
	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.falltiles
	db $44,$8E
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Kneeling GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Kneeling:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
	-
	LDA $00
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.voff
	db $F0,$00

.standtiles
	db $A4,$C4
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Walking GFX with hardcoded directions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_WalkingLeft:
	LDA #$01
	STA $0C
	BRA anyway
Graphics_WalkingRight:	
	LDA #$00
	STA $0C
anyway:
	PLX
	JSL !GET_DRAW_INFO

	LDA !GFXTimer
	BNE +
	LDA #$17
	STA !GFXTimer
+

	LDA $00
	STA $6300,y

	PHX
	LDA !GFXTimer
	TAX
	LDA $01
	CLC
	ADC .voff,x
	STA $6301,y

	LDA .feettiles,x
	STA $6302,y
	PLX

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY #4

	LDA $00
	STA $6300,y

	PHX
	LDA !GFXTimer
	TAX
	LDA $01
	CLC
	ADC .voff,x
	ADC #$F0
	STA $6301,y
	PLX

	LDA .headtile
	STA $6302,y

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64

	STA $6303,y

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.feettiles
	db $2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A
	db $4A,$4A,$4A,$4A,$4A,$4A,$4A,$4A
	db $6A,$6A,$6A,$6A,$6A,$6A,$6A,$6A

.headtile
	db $40

.voff
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $01,$01,$01,$01,$01,$01,$01,$01
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Knockback GFX 1 + 2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_HurtKnockBack:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$03
	-
	
	LDA $0C
	BNE +
	LDA $00
	ADC .xoff1,x
	STA $6300,y
	BRA ++
+
	LDA $00
	ADC .xoff2,x
	STA $6300,y
++
	LDA $01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$03                ; This means we drew 4 tiles
	JSL $01B7B3
	RTS

.voff
	db $00,$00
	db $10,$10
.xoff1
	db $00,$10
	db $00,$10
.xoff2
	db $10,$00
	db $10,$00
.standtiles
	db $A0,$A2
	db $C0,$C2
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Knockback GFX 2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_HurtKnockBack2:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$03
-
	LDA $0C
	BNE +
	LDA $00
	ADC .xoff1,x
	STA $6300,y
	BRA ++
+
	LDA $00
	ADC .xoff2,x
	STA $6300,y
++

	LDA $01
	ADC .voff,x
	STA $6301,y

	LDA .standtiles,x
	STA $6302,y

	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	ORA #$80
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$03                ; This means we drew 4 tiles
	JSL $01B7B3
	RTS

.voff
	db $00,$00
	db $10,$10
.xoff1
	db $00,$10
	db $00,$10
.xoff2
	db $10,$00
	db $10,$00
.standtiles
	db $C0,$C2
	db $A0,$A2
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Lying GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_Lying:
	PLX
	JSL !GET_DRAW_INFO
	LDA !Direction
	STA $0C
	PHX
	LDX #$01
-
	LDA $0C
	BNE +
	LDA $00
	ADC .xoff1,x
	STA $6300,y
	BRA ++
+
	LDA $00
	ADC .xoff2,x
	STA $6300,y
++

	LDA $01
	STA $6301,y

	LDA .falltiles,x
	STA $6302,y
	
	LDA $0C
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ASL A
	ORA #$0F
	ORA $64
	STA $6303,y

	INY
	INY
	INY
	INY
	DEX
	BPL -
	PLX

	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$01                ; This means we drew two tiles
	JSL $01B7B3
	RTS

.xoff1
	db $00,$10
.xoff2
	db $10,$00
.falltiles
	db $86,$88

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;OH GOD NOOOOOOO GFX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Graphics_OH_GOD_NO:
	PLX
	JSL !GET_DRAW_INFO

	PHX
	LDX #$03
	-
	LDA $00
	CLC
	ADC .messagetilesx,x
	STA $6300,y

	LDA $01
	CLC
	ADC #$01
	ADC .messagetilesy,x
	STA $6301,y

	LDA .messagetiles,x
	STA $6302,y

	LDA #$0F
	ORA $64
	STA $6303,y

	INY #4
	DEX
	BPL -
	PLX

	LDA $00
	STA $6300,y

	LDA $01
	SEC
	SBC #$06
	STA $6301,y

	PHX
	LDA $14
	LSR A
	LSR A
	AND #$01
	TAX
	LDA .headtiles,x
	STA $6302,y
	PLX
	
	LDA #$0F
	ORA $64
	STA $6303,y
	
	LDY #$02                ; #$02 means the tiles are 16x16
	LDA #$04                ;
	JSL $01B7B3
	RTS
	

.messagetiles
	db $0C,$0E,$2C,$2E
.messagetilesx
	db $E8,$F8,$E8,$F8
.messagetilesy
	db $E0,$E0,$F0,$F0
	
.headtiles
db $82,$84